% Bank_Balance_While.m - Greg Bucks - 10/8/2013
% Description: this script will compute the balance of a bank account, 
% assuming an initial deposit of $1000, and monthly deposit of $500, and an
% annual interest rate of 5% compounded monthly.  It will continue to
% compute the balance until the value of the account exceeds $100,000, at
% which point it will display the balance and the number of months required
% to reach this amount.
% Usage: >> Bank_Balance_While;

% set up initial values
account_value = 1000;           % initial deposit
monthly_deposit = 500;          % monthly deposit
annual_rate = 0.05;             % annual interest rate
monthly_rate = annual_rate/12;  % monthly rate
duration = 0;                   % number of months taken to reach limit
account_limit = 100000;         % desired ending balance on the account

% begin computations to determine the length of time required to reach the
% account limit

while account_value < account_limit
    account_value = account_value + monthly_deposit + monthly_rate*account_value;
    duration = duration + 1;
end

% display results
fprintf('It takes a total of %d months or %0.2f years to reach a value of $%0.2f in your account.\n',duration,duration/12,account_limit);
fprintf('The final value in the account is $%0.2f.\n',account_value);